const Joi = require("@hapi/joi");

// Register Validation
const registerValidation = (data) => {
  const schema = Joi.object({
    name: Joi.string().min(4).required(),
    surname: Joi.string().min(4).required(),
    email: Joi.string().required().email(),
    mobile: Joi.string()
      .length(9)
      .pattern(/^[0-9]+$/)
      .required(),
    password: Joi.required(),
  });

  return schema.validate(data);
};

// Login Validation
const loginValidation = (data) => {
  const schema = Joi.object({
    email: Joi.string().required().email(),
    password: Joi.string().min(6).required(),
  });

  return schema.validate(data);
};

// address Validation
const addressValidation = (data) => {
  console.log(data);
  const schema = Joi.object({
    user_id: Joi.required(),
    name: Joi.string().min(1).required(),
    address: Joi.string().min(5).required(),
    ext_number: Joi.number().required(),
    int_number: Joi.number().required(),
    reference: Joi.optional(),
    store_id: Joi.required(),
    lat: Joi.string().required(),
    longit: Joi.string().required(),
  });

  return schema.validate(data);
};

const cardValidation = (data) => {
  const schema = Joi.object({
    user_id: Joi.required(),
    card_holder_name: Joi.string().min(1).required(),
    card_number: Joi.string().min(16).max(16).required(),
    card_cvv: Joi.number().required(),
    card_year: Joi.number().required(),
    card_month: Joi.number().required(),
  });

  return schema.validate(data);
};

module.exports.registerValidation = registerValidation;
module.exports.loginValidation = loginValidation;
module.exports.addressValidation = addressValidation;
module.exports.cardValidation = cardValidation;
