// Create a separate server for Socket.IO
const server = require("http").createServer();
const io = require("socket.io")(server, {
  cors: {
    origin: "*",
    methods: ["GET", "POST"],
  },
});

io.on("connection", (socket) => {
  console.log("Socket.IO client connected");

  // Handle Socket.IO events
});

// Start the Socket.IO server
server.listen(40171, () => {
  console.log("Socket.IO server is running on port: 40171 ");
});

module.exports = io;
