const jwt = require('jsonwebtoken');

// create a medilware function to validate the token and
module.exports = function(req, res, next) {
    const token = req.header('auth_token');
    if (!token) res.status(401).send('Acceso Denegado');

    try {
        const verified = jwt.verify(token, process.env.TOKEN_KEY);
        req.user = verified;
        next();
    } catch (err) {
        res.status(400).send('Token Invalido');
    }
}