const router = require("express").Router();
const verify = require("./validateToken");
const { addressValidation } = require("../utilities/validator");
const db = require("../database/connection");
const fs = require("fs");

//  get stores for celphone app
router.get("/", verify, async (req, res) => {
  const sql = "SELECT * FROM store where deleted = 0 and state = 1";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "No ay ningun tienda grabada!" });

      res.send({ store: result, success: "true" });
    }
  });
});

//  get store for admin dashboard
router.get("/admin", verify, async (req, res) => {
  const sql = "SELECT * FROM store where deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "No ay ningun tienda grabado!" });

      res.send({ store: result, success: "true" });
    }
  });
});

router.post("/saveStore", verify, async (req, res) => {
  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/store/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/store/" + url;

    fs.writeFile(
      path,
      base64Image,
      { encoding: "base64" },
      async function (err) {
        if (err) {
          res.send({ err });
          console.log(err);
        } else {
          try {
            const { name, address, open, close, state } = req.body.item;
            const menuData = {
              name,
              address,
              img,
              open,
              close,
              state,
            };

            var sql = "INSERT INTO store SET ? ";

            try {
              await db.query(sql, menuData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          } catch (error) {}
        }
      }
    );
  }
});

router.post("/updateStore/:id", async (req, res) => {
  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/store/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/store/" + url;

    if (image.includes("base64")) {
      fs.writeFile(
        path,
        base64Image,
        { encoding: "base64" },
        async function (err) {
          if (err) {
            res.send({ err });
            console.log(err);
          } else {
            const { id, name, address, open, close, state } = req.body.item;
            const menuData = {
              name,
              address,
              img,
              open,
              close,
              state,
            };

            var sql = "UPDATE store SET ? WHERE id = " + id + "";

            try {
              await db.query(sql, menuData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          }
        }
      );
    } else {
      const { id, name, address, open, close, state } = req.body.item;
      const menuData = {
        name,
        address,
        open,
        close,
        state,
      };
      //  console.log(menuData)

      var sql = "UPDATE store SET ? WHERE id = " + id + "";

      try {
        await db.query(sql, menuData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  }
});

router.post("/deleteStore/:id", async (req, res) => {
  const id = req.params.id;
  const deleted = 1;
  const menuData = { deleted };

  var sql = "UPDATE store SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, menuData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send(id);
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

module.exports = router;
