const router = require("express").Router();
const verify = require("./validateToken");
const db = require("../database/connection");
const fs = require("fs");
var voucher_codes = require("voucher-code-generator");
const { exit } = require("process");

const io = require("../utilities/socketio");

router.get("/", verify, async (req, res) => {
  const sql = "SELECT * FROM coupon where deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(200)
          .send({ success: "false", message: "No ay coupones desponisble!" });

      res.send({ coupon: result, success: "true" });
    }
  });
  db.end;
});

async function testLoop(cartId) {
  var sql =
    "select c.item_amount, c.adicional_ids, m.* from cart_item as c, menu as m where c.cart_id = " +
    cartId +
    " and m.id = c.menu_id";

  try {
    await db.query(sql, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        // console.log(result);
        return result;
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
}

router.post("/getOrderItems", verify, async (req, res) => {
  const cartId = req.body.item.cartId;
  // const cartId = req.body.cartId;  // postman

  // await testLoop(cartId).then(data => {
  //     console.log(data);
  //  res.send({Items : data,  success: "true"});
  // });

  var sql =
    "select c.item_amount, c.adicional_ids, m.* from cart_item as c, menu as m where c.cart_id = " +
    cartId +
    " and m.id = c.menu_id";

  try {
    let additionals = [];

    let getItemList = new Promise((resolve, reject) => {
      db.query(sql, (error, result, fields) => resolve(result));
    });
    const ItemsList = await getItemList;

    // get Additionals
    let loopItems = new Promise(async (resolve, reject) => {
      for (let i = 0; i < ItemsList.length; i++) {
        if (ItemsList[i].adicional_ids != null) {
          const additional_string = ItemsList[i].adicional_ids;
          const additional_array = additional_string.split(",");
          //  looping and getting additionals

          let loopAdditionals = new Promise(async (resolve, reject) => {
            for (let j = 0; j < additional_array.length; j++) {
              const additionalId = additional_array[j];
              try {
                sql1 =
                  "select * from additional_item where id = " +
                  additionalId +
                  "";
                let getAdditionalList = new Promise((resolve, reject) => {
                  db.query(sql1, (error, result, fields) => resolve(result));
                });

                const adds = await getAdditionalList;
                additionals.push(adds);
                // console.log(adds)
              } catch (error) {
                console.log(error);
              }
            }

            //  console.log(additionals)
            ItemsList[i].additional = additionals;
            return resolve(additionals);
          });
          const tt = await loopAdditionals;
        }
      }
      return resolve(ItemsList);
    });

    let test = await loopItems;
    // console.log(test);
    res.send({ Items: ItemsList, success: "true" });
  } catch (error) {
    return res.status(400).send(error);
  }
  db.end;

  // try {

  //     const itemsList = await db.query(sql, (error, result, fields) => { return result; });
  //     //  res.send({Items : itemsList,  success: "true"});
  //     console.log(itemsList)
  //     for (const item in  itemsList) {
  //         // const item = itemsList[i];
  //         // console.log(item)
  //     }
  //         // await db.query(sql, (error, result, fields) => {
  //         // if (error) {
  //         //     const errorMessage = error.sqlMessage;
  //         //     return res.status(400).send(errorMessage);
  //         // } else {
  //         //     //   res.send({Items : result,  success: "true"});
  //         //     for (let i = 0; i < result.length; i++) {
  //         //         const element = result[i];
  //         //         let item = async (element) => {
  //         //             await new Promise ( rerslove => getAdditionalList(element))
  //         //                 console.log(rerslove);
  //         //             }

  //         //     }

  //         //     console.log("out");
  //             // result.forEach( async item => {
  //             //     if (item.adicional_ids != null) {
  //             //         const additional_string = item.adicional_ids;
  //             //         const additional_array = additional_string.split(',');
  //             //          var additional_list = [];
  //             //         additional_array.forEach( async additionalId =>  {

  //             //             sql1 = 'select * from menu_additional where id = ' + additionalId + '';
  //             //             await db.query(sql1, (error, additionals, fields) => {
  //             //                 if (error) {
  //             //                     const errorMessage = error.sqlMessage;
  //             //                     return res.status(400).send(errorMessage);
  //             //                 } else {
  //             //                     additional_list.push(additionals);
  //             //                     // item['additional_list'] = additionals;

  //             //                 }
  //             //              })
  //             //              console.log(additional_list)
  //             //         })

  //             //     }

  //             // })
  //             //
  //         // }
  // // }
  //     // );

  //     } catch (error) {
  //         return res.status(400).send(error);
  //     }
});

async function getAdditionalList(item) {
  sql1 = "select * from menu_additional where id = 2";
  await db.query(sql1, (error, additionals, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      return res.status(400).send(errorMessage);
    } else {
      // additional_list.push(additionals);
      // item['additional_list'] = additionals;
      return additionals;
    }
  });
  db.end;
}

router.post("/getOrders", async (req, res) => {
  const storId = req.body.item.storeId;
  var sql =
    "SELECT c.*, c.state as status, u.name, u.surname, u.email, ad.address, ad.lat, ad.longit, ad.ext_number, ad.int_number, ad.reference FROM `cart` as c, user as u, address as ad where c.type = 0 and c.store_id =  " +
    storId +
    " and Date(c.created_time) >= Date(current_timestamp()) and c.user_id = u.id and ad.id = c.address_id order by c.created_time asc";
  try {
    await db.query(sql, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        // io.on("connection", (socket) => {
        //   console.log("a user connected");
        //   // socket.emit("message", "Hello from server!");

        //   socket.on("message", (data) => {
        //     console.log("Data received from client:", data);
        //   });

        //   socket.emit("newOrder", true);
        // });
        console.log("befor Socket");
        const testIO = io.emit("newOrder", true);
        console.log(testIO);
        res.send({ orders: result, success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/getOrdersPickup", async (req, res) => {
  const storId = req.body.item.storeId;
  var sql =
    "SELECT c.*, c.state as status, u.name, u.surname, u.email, ad.address, ad.lat, ad.longit, ad.ext_number, ad.int_number, ad.reference FROM `cart` as c, user as u, address as ad where c.type = 1 and c.store_id =  " +
    storId +
    " and Date(c.created_time) >= Date(current_timestamp()) and c.user_id = u.id and ad.id = c.address_id order by c.created_time asc";
  try {
    await db.query(sql, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        // io.on("connection", (socket) => {
        //   console.log("a user connected");
        //   // socket.emit("message", "Hello from server!");

        //   socket.on("message", (data) => {
        //     console.log("Data received from client:", data);
        //   });

        //   socket.emit("newOrder", true);
        // });
        console.log("befor Socket");
        const testIO = io.emit("newOrder", true);
        console.log(testIO);
        res.send({ orders: result, success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/getOrdersByUser", async (req, res) => {
  // console.log(req.body);
  const userId = req.body.userId;
  // var sql = "SELECT c.*, m.name, m.img FROM `cart` as c, cart_item as ci, menu as m where user_id = " + userId + " and ci.cart_id = c.id and m.id = ci.menu_id ORDER BY id DESC LIMIT 10";
  var sql = "SELECT * FROM cart where  user_id = ?";
  try {
    await db.query(sql, userId, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send({ orders: result, success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/getOrdersByMotorizado", async (req, res) => {
  const storId = req.body.item.storeId;
  const delivery_boy_id = req.body.item.delivery_boy_id;
  var sql =
    "SELECT c.*, c.state as status, u.name, u.surname, u.email, ad.address, ad.lat, ad.longit, ad.ext_number, ad.int_number, ad.reference FROM `cart` as c, user as u, address as ad where c.store_id =  " +
    storId +
    " and c.delivery_boy_id =  " +
    delivery_boy_id +
    " and Date(c.created_time) >= Date(current_timestamp()) and c.user_id = u.id and ad.id = c.address_id";
  try {
    await db.query(sql, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send({ orders: result, success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/setStatusDecline", async (req, res) => {
  const status = 100; // order declined
  const cartId = req.body.item.cartId;

  var sql = "UPDATE cart SET state= " + status + " where id = " + cartId + "";

  try {
    await db.query(sql, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send({ orders: result, success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/setStartStatus", async (req, res) => {
  const status = 1;
  const cartId = req.body.item.cartId;

  // console.log(cartId);

  // to add 30min to the date and
  const minutesToAdd = 30;
  const startDate = new Date("yy/m/d h:m:s");
  const addedDate = new Date(startDate.getTime() + minutesToAdd * 60000);

  var sql =
    "UPDATE cart SET state= " +
    status +
    " ,  order_start= current_timestamp() + INTERVAL 30 MINUTE	 where id = " +
    cartId +
    "";
  try {
    await db.query(sql, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send({ orders: result, success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/setStatusDespatch", async (req, res) => {
  // console.log(req.body.item.delivery_boy_id);
  const status = 3;
  const delivery_boy_id = req.body.item.delivery_boy_id;

  var sql =
    "UPDATE cart SET state= " +
    status +
    " where delivery_boy_id = " +
    delivery_boy_id +
    "";
  try {
    await db.query(sql, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send({ orders: result, success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/setStatusDelivered", async (req, res) => {
  const status = 4;
  const cartId = req.body.item.cartId;

  // console.log(cartId);
  // to add 30min to the date and

  var sql = "UPDATE cart SET state= " + status + " where id = " + cartId + "";
  // console.log(sql);
  try {
    await db.query(sql, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send({ orders: result, success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/setStatus", async (req, res) => {
  const status = req.body.item.status;
  const cartId = req.body.item.cardId;
  var sql = "UPDATE cart SET state= " + status + " where id = " + cartId + "";
  try {
    await db.query(sql, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send({ orders: result, success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/deleteCoupon/:id", async (req, res) => {
  const id = req.params.id;
  const deleted = 1;
  const couponData = { deleted };

  var sql = "UPDATE coupon SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, couponData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send(id);
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

// Mobile App Section
router.get("/all", verify, async (req, res) => {
  const sql =
    "SELECT * FROM coupon where deleted = 0 and is_public = 1 ORDER BY points";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(200)
          .send({ success: "false", message: "No ay coupones desponisble!" });

      res.send({ coupon: result, success: "true" });
    }
  });
  db.end;
});

router.get("/byUser/:userId", verify, async (req, res) => {
  const id = req.params.userId;

  const sql =
    "SELECT c.* FROM `user_coupon` uc, coupon c where uc.coupon_id = c.id and uc.user_id = " +
    id +
    " and c.state =1 and c.deleted = 0 and c.is_public = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      // if (result.length === 0) return res.status(400).send({ success: "false", message: "No ay coupones desponisble!" });

      res.send({ coupons: result, success: "true" });
    }
  });
  db.end;
});

router.post("/getOrderById", verify, async (req, res) => {
  // console.log(req.body);
  const sql = "SELECT * FROM `cart` where id = ?";
  await db.query(sql, req.body.orderId, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      // if (result.length === 0) return res.status(400).send({ success: "false", message: "No ay coupones desponisble!" });

      res.send({ Order: result, success: "true" });
    }
  });
  db.end;
});

module.exports = router;
