const router = require("express").Router();
const verify = require("./validateToken");
const { cardValidation } = require("../utilities/validator");
const db = require("../database/connection");

const mp = require("mercadopago");
const io = require("../utilities/socketio");

router.post("/", verify, async (req, res) => {});

router.post("/makePayment", verify, async (req, res) => {
  var userId = req.body.user["id"];
  var cartItems = JSON.parse(req.body.cart);
  var addressId = req.body.address["id"];
  var total = req.body.total;
  var type = req.body.type;
  var cart_id = null;

  var newOrder = null;

  if (type === 0) {
    var storeId = req.body.address["store_id"];
  } else {
    var storeId = req.body.address["id"];
  }

  var couponData = req.body.userCoupon;
  if (Object.keys(couponData).length > 0) {
    console.log(couponData);
    console.log(req.body);
    console.log(req.body.token);
  } else {
    console.log(req.body);
  }

  // return res.send({ success: false, msg: "testing" });

  console.log(process.env.MIRCADOPAGO_TOKEN);

  var isSuccess = false;
  var msg = "";

  console.log(userId);
  // console.log(cartItems);
  console.log(storeId);
  console.log(addressId);
  console.log(total);

  const envToken = process.env.MIRCADOPAGO_TOKEN;

  mp.configure({
    access_token: envToken,
  });

  //     var payment_data = {
  //   transaction_amount: Number(req.body.total),
  //   token: req.body.token,
  //   installments: 1,
  //   payment_method_id: 'Visa',
  //   payer: {
  //       email: req.body.user['email'],
  //   }
  // };

  // mp.payment.save(payment_data)
  //   .then(function(response) {
  //     res.status(response.status).json({
  //       status: response.body.status,
  //       status_detail: response.body.status_detail,
  //       id: response.body.id
  //     });
  //   })
  //   .catch(function(error) {
  //     res.status().send(error);
  //   });

  try {
    var payment_data = {
      transaction_amount: Number(req.body.total),
      token: req.body.token,
      installments: 1,
      payment_method_id: "visa",
      payer: {
        // email: req.body.user["email"],
        email: "test_user_45701777@testuser.com",
      },
    };

    console.log(payment_data);

    var cartData = [
      (user_id = userId),
      (store_id = storeId),
      (address_id = addressId),
      (total = total),
      (type = type),
    ];

    await mp.payment.create(payment_data).then(function (data) {
      const status = data.response["status"];

      console.log(status);
      if (status == "approved") {
        isSuccess = true;
        msg = data.response["status_detail"];

        // create the cart
        var sql =
          "INSERT INTO `cart`(`user_id`, `store_id`, `address_id`, `total` , `type`) VALUES (" +
          userId +
          "," +
          storeId +
          "," +
          addressId +
          "," +
          total.toString() +
          "," +
          type +
          ")";
        console.log(sql);
        db.query(sql, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            console.log("error", errorMessage);
            //   return res.status(400).send(error.sqlMessage);
          } else {
            // TODO insert Coupon if exists
            cart_id = result.insertId;
            for (cartItem of cartItems) {
              console.log(cartItem);
              const id = cartItem["cart"].id;
              var additional = null;
              if (cartItem["cart"].additional != null) {
                additional = cartItem["cart"].additional.toString();
              }

              const { amount, total } = cartItem;
              const item = {
                cart_id,
                menu_id: id,
                adicional_ids: additional,
                item_amount: amount,
                price: total,
              };
              var sql2 = "INSERT INTO `cart_item` SET ?";

              db.query(sql2, item, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  console.log("error", errorMessage);
                }
              });
            }
            var sql3 = "Select * from `cart` where id = ?";

            db.query(sql3, cart_id, (error, result2, fields) => {
              if (error) {
                const errorMessage = error.sqlMessage;
                console.log("error", errorMessage);
              }
              console.log("Cart get: ", result2);
              newOrder = result2;
              db.end;
              // send socket message to update the orders
              io.on("connection", (socket) => {
                console.log("a user connected");
                // socket.emit("message", "Hello from server!");

                socket.on("message", (data) => {
                  console.log("Data received from client:", data);
                });

                socket.emit("newOrder", true);
              });
              res.send({
                success: isSuccess,
                msg: msg,
                cartId: cart_id,
                Order: newOrder,
              });
            });
          }
        });
      } else if (status == "in_process") {
        // TODO create inprocess table to show in th dashboard
        isSuccess = false;
        msg = "No pudimos procesar tu pago.";
        db.end;
        res.send({ success: isSuccess, msg: msg });
      } else if (status == "rejected") {
        const details = data.response["status_detail"];
        switch (details) {
          case "cc_rejected_bad_filled_card_number":
            isSuccess = false;
            msg = "Revisa el número de tarjeta.";
            break;
          case "cc_rejected_bad_filled_date":
            isSuccess = false;
            msg = "Revisa la fecha de vencimiento.";
            break;
          case "cc_rejected_bad_filled_other":
            isSuccess = false;
            msg = "Revisa los datos.";
            break;
          case "cc_rejected_bad_filled_security_code":
            isSuccess = false;
            msg = "Revisa el código de seguridad de la tarjeta.";
            break;

          default:
            isSuccess = false;
            msg = "No pudimos procesar tu pago.";
            break;
        }
        db.end;
        res.send({ success: isSuccess, msg: msg });
      }
    });
    db.end;
  } catch (error) {
    console.log(error);
  }
});

router.post("/setDefault", verify, async (req, res) => {
  // console.log(req.body.id);

  const userId = req.body.user_id;
  const id = req.body.id;

  var sql1 = "update card set is_default = 0 where user_id = " + userId + "";
  await db.query(sql1, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      // console.log("error",errorMessage);
      return res.status(400).send(error.sqlMessage);
    }
  });

  var sql =
    "update card set is_default = 1 where user_id = " +
    userId +
    " and id = " +
    id +
    "";
  await db.query(sql, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      // console.log("error",errorMessage);
      return res.status(400).send(error.sqlMessage);
    } else {
      res.send({ success: "true" });
    }
  });
  db.end;
});

router.post("/saveCard", verify, async (req, res) => {
  //validate the data
  const { error } = cardValidation(req.body);
  if (error) return res.status(400).send(error.details[0].message);

  const {
    user_id,
    card_holder_name,
    card_number,
    card_year,
    card_month,
    card_cvv,
  } = req.body;
  const cardData = {
    user_id,
    card_holder_name,
    card_number,
    card_year,
    card_month,
    card_cvv,
  };

  //  remove all defaults cards
  var sql1 = "update card set is_default = 0 where user_id = " + user_id + "";
  await db.query(sql1, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      // console.log("error",errorMessage);
      return res.status(400).send(error.sqlMessage);
    }
  });

  var sql = "INSERT INTO card SET ?";

  await db.query(sql, cardData, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      // console.log("error",errorMessage);
      return res.status(400).send(error.sqlMessage);
    } else {
      // console.log("Result",result);
      res.send({
        id: result.insertId,
        message: "card created",
        success: "true",
      });
    }
  });
  db.end;
});

router.post("/updateCard", async (req, res) => {
  console.log(req.body);

  const { id, card_holder_name, card_number, card_year, card_month, card_cvv } =
    req.body;
  const cardData = {
    card_holder_name,
    card_number,
    card_year,
    card_month,
    card_cvv,
  };

  var sql = "UPDATE card SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, cardData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send({ card: req.body, message: "card updated!", success: "true" });
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/deleteStore/:id", async (req, res) => {
  const id = req.params.id;
  const deleted = 1;
  const menuData = { deleted };

  var sql = "UPDATE store SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, menuData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send(id);
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

module.exports = router;
