const router = require("express").Router();
const verify = require("./validateToken");
const db = require("../database/connection");
const fs = require("fs");

router.get("/", verify, async (req, res) => {
  const sql = "SELECT * FROM menu where deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "El menú esta vacío!" });

      res.send({ menu: result, success: "true" });
    }
  });
});

router.post("/checkAssign/:id", verify, async (req, res) => {
  const id = req.params.id;
  const sql =
    "SELECT m.*, sm.id as isAssigned FROM `menu` m left JOIN staff_menu sm on sm.store_id = " +
    id +
    " and sm.menu_id = m.id and sm.deleted = 0";
  await db.query(sql, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "El menú esta vacío!" });

      res.send({ menu: result, success: "true" });
    }
  });
  db.end;
});

router.post("/checkAssignAdditional/:id", verify, async (req, res) => {
  const id = req.params.id;
  const sql =
    "SELECT m.*, ma.id as isAssigned FROM `menu` m left JOIN menu_additional ma on ma.additional_id = " +
    id +
    " and ma.menu_id = m.id and ma.deleted = 0";
  await db.query(sql, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "El menú esta vacío!" });

      res.send({ menu: result, success: "true" });
    }
  });
});

router.post("/", verify, async (req, res) => {
  const catId = req.body.id;
  const storeId = req.body.storeId;
  // const sql = 'SELECT * FROM menu where deleted = 0 and state = 1 and category_id = ?';

  const sql =
    "SELECT m.* FROM menu m , staff_menu sm where m.deleted = 0 and m.state = 1 and m.category_id = " +
    catId +
    " and sm.store_id = " +
    storeId +
    " and m.id = sm.menu_id and sm.deleted = 0 and sm.state = 1";
  await db.query(sql, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({
            success: "false",
            message: "No ay ningun dirección grabado!",
          });

      res.send({ menu: result, success: "true" });
    }
  });
  db.end;
});

router.post("/saveMenu", verify, async (req, res) => {
  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/menu/menu/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/menu/menu/" + url;

    fs.writeFile(
      path,
      base64Image,
      { encoding: "base64" },
      async function (err) {
        if (err) {
          res.send({ err });
          console.log(err);
        } else {
          try {
            const {
              name,
              description,
              price,
              state,
              category_id,
              category_name,
            } = req.body.item;
            const menuData = {
              category_id,
              name,
              description,
              img,
              price,
              state,
              category_name,
            };
            //  console.log(menuData)

            var sql = "INSERT INTO menu SET ? ";

            try {
              await db.query(sql, menuData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          } catch (error) {}
        }
      }
    );
  }

  //     //validate the data
  //     const { error } = addressValidation(req.body);
  //     if (error) return res.status(400).send(error.details[0].message);

  //   const { user_id, name, address, ext_number, int_number, reference } = req.body;
  //   const addressData = {
  //     user_id, name, address, ext_number, int_number, reference
  //   };

  //   var sql = "INSERT INTO address SET ?";

  //   await db.query(sql, addressData, (error, result, fields) => {
  //     if (error) {
  //       const errorMessage = error.sqlMessage;

  //         return res.status(400).send(error.sqlMessage);

  //     } else {
  //       res.send({id : result.insertId, message : 'address created',  success: "true"});
  //     }

  //   });
});

router.post("/updateMenu/:id", async (req, res) => {
  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/menu/menu/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/menu/menu/" + url;

    if (image.includes("base64")) {
      fs.writeFile(
        path,
        base64Image,
        { encoding: "base64" },
        async function (err) {
          if (err) {
            res.send({ err });
            console.log(err);
          } else {
            const {
              id,
              name,
              description,
              price,
              state,
              category_id,
              category_name,
            } = req.body.item;
            const menuData = {
              category_id,
              name,
              description,
              img,
              price,
              state,
              category_name,
            };
            //  console.log(menuData)

            var sql = "UPDATE menu SET ? WHERE id = " + id + "";

            try {
              await db.query(sql, menuData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          }
        }
      );
    } else {
      const {
        id,
        name,
        description,
        price,
        state,
        category_id,
        category_name,
      } = req.body.item;
      const menuData = {
        category_id,
        name,
        description,
        price,
        state,
        category_name,
      };
      //  console.log(menuData)

      var sql = "UPDATE menu SET ? WHERE id = " + id + "";

      try {
        await db.query(sql, menuData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  }
});

router.post("/deleteMenu/:id", async (req, res) => {
  const id = req.params.id;
  const deleted = 1;
  const menuData = { deleted };

  var sql = "UPDATE menu SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, menuData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send(id);
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/updateAssignMenu", async (req, res) => {
  const id = req.body.item.id;
  const isChecked = req.body.item.isChecked;
  const storeId = req.body.item.storeId;

  const deleted = isChecked === true ? 0 : 1;
  console.log(deleted);
  //check if user exist
  const sql =
    "SELECT * FROM staff_menu where store_id = " +
    storeId +
    " and menu_id = " +
    id +
    ";";

  await db.query(sql, async (error, result) => {
    if (error)
      return res
        .status(400)
        .send({ success: "false", message: error.details[0].message });

    if (result.length === 0) {
      var sql2 =
        "INSERT INTO staff_menu (menu_id, store_id ) VALUE(" +
        id +
        "," +
        storeId +
        ")";
      try {
        await db.query(sql2, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
      } catch (error) {
        return res.status(400).send(error);
      }
    } else {
      var sql2 =
        "UPDATE staff_menu SET deleted = " +
        deleted +
        " WHERE menu_id = " +
        id +
        " and store_id = " +
        storeId +
        "";
      console.log(sql2);
      try {
        await db.query(sql2, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  });
  db.end;
});

router.post("/updateAssignMenuAdditional", async (req, res) => {
  const id = req.body.item.id;
  const isChecked = req.body.item.isChecked;
  const additionalId = req.body.item.additionalId;

  const deleted = isChecked === true ? 0 : 1;
  console.log(deleted);
  //check if user exist
  const sql =
    "SELECT * FROM menu_additional where additional_id = " +
    additionalId +
    " and menu_id = " +
    id +
    ";";

  await db.query(sql, async (error, result) => {
    if (error)
      return res
        .status(400)
        .send({ success: "false", message: error.details[0].message });

    if (result.length === 0) {
      var sql2 =
        "INSERT INTO menu_additional (menu_id, additional_id ) VALUE(" +
        id +
        "," +
        additionalId +
        ")";
      try {
        await db.query(sql2, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
      } catch (error) {
        return res.status(400).send(error);
      }
    } else {
      var sql2 =
        "UPDATE menu_additional SET deleted = " +
        deleted +
        " WHERE menu_id = " +
        id +
        " and additional_id = " +
        additionalId +
        "";
      console.log(sql2);
      try {
        await db.query(sql2, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  });
  db.end;
});

//  staff

router.post("/staffMenu/:id", verify, async (req, res) => {
  // TODO make store_id dinamic

  const id = req.params.id;
  const sql =
    "SELECT m.* , sm.state as storeState FROM `menu` m , staff_menu  sm where sm.store_id = " +
    id +
    " and m.id = sm.menu_id and m.state = 1 and m.deleted = 0 and sm.deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({
            success: "false",
            message: "No ay ningun dirección grabado!",
          });

      res.send({ menu: result, success: "true" });
    }
  });
  db.end;
});

router.post("/updateState/:id", async (req, res) => {
  if (req.body.item) {
    const { id, state } = req.body.item;
    var sql =
      "UPDATE staff_menu SET state = " +
      state +
      " WHERE menu_id = " +
      id +
      " and store_id = 1";
    try {
      await db.query(sql, (error, result, fields) => {
        if (error) {
          const errorMessage = error.sqlMessage;
          return res.status(400).send(errorMessage);
        } else {
          res.send(req.body.item);
        }
      });
      db.end;
    } catch (error) {
      return res.status(400).send(error);
    }
  }
});

//  app calls update

module.exports = router;
