const router = require('express').Router();
const verify = require('./validateToken');
const db = require('../database/connection');

router.get('/', verify, async (req, res) => {

    const sql = 'SELECT * FROM delivery_zone where deleted = 0';
    await db.query(sql, req.body.id, (error, result) => {
        if (error) {
     
      
        return res.status(400).send(error.sqlMessage);

      
        } else {
            if (result.length === 0) return res.status(400).send({ success: "false", message: "No ay Zonas de Delivery!" });
            
      res.send({menu : result,  success: "true"});
    }
    });
});


router.post('/saveDeliveryZones', verify, async (req, res) => {
    
    if (req.body.item) {
        try {
            const { name, store_id, store_name, coordinates,state } = req.body.item;
            const deliveryZoneData = {
                name, store_id, store_name, coordinates, state
            };
            //  console.log(menuData
            var sql = "INSERT INTO delivery_zone SET ? "
            try {
                await db.query(sql, deliveryZoneData, (error, result, fields) => {
                    if (error) {
                        const errorMessage = error.sqlMessage;
                        return res.status(400).send(errorMessage);
                    } else {
                        res.send(req.body.item);
                    }
                });
            
            } catch (error) {
                return res.status(400).send(error);
            }
           
        } catch (error) {
           
        }
    }
});

router.post('/updateDeliveryZones/:id', verify, async (req, res) => {
    if (req.body.item) {
        const { id, name, store_id, store_name, coordinates,state } = req.body.item;
        const deliveryZoneData = {
            name, store_id, store_name, coordinates, state
        };
        var sql = "UPDATE delivery_zone SET ? WHERE id = "+id+""
        try {
            await db.query(sql, deliveryZoneData, (error, result, fields) => {
            if (error) {
                const errorMessage = error.sqlMessage;
                return res.status(400).send(errorMessage);
            } else {
                 res.send(req.body.item);
            }
        });
            
        } catch (error) {
            return res.status(400).send(error);
        }  
    }

});
router.get('/getById/:id', verify, async (req, res) => {
    const id = req.params.id

    const sql = 'SELECT * FROM delivery_zone where id = '+id+'';
    await db.query(sql, req.body.id, (error, result) => {
        if (error) {
     
      
        return res.status(400).send(error.sqlMessage);

      
        } else {
            if (result.length === 0) return res.status(400).send({ success: "false", message: "El menú esta vacío!" });
            
      res.send({zone : result,  success: "true"});
    }
    });
});

router.post('/deleteDeliveryZones/:id', verify, async (req, res) => {

    const id = req.params.id
    const deleted = 1;
    const menuData = { deleted };

    var sql = "UPDATE delivery_zone SET ? WHERE id = "+id+""

    try {
        await db.query(sql, menuData, (error, result, fields) => {
        if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
        } else {
            res.send(id);
        }
    });
        
    } catch (error) {
        return res.status(400).send(error);
    }
});

// Additional Items Calls

router.get('/item', verify, async (req, res) => {

    const sql = 'SELECT * FROM additional_item where deleted = 0';
    await db.query(sql, req.body.id, (error, result) => {
        if (error) {
     
      
        return res.status(400).send(error.sqlMessage);

      
        } else {
            if (result.length === 0) return res.status(400).send({ success: "false", message: "El menú esta vacío!" });
            
      res.send({menu : result,  success: "true"});
    }
    });
});


router.post('/saveAdditionalItem', verify, async (req, res) => {
    
    if (req.body.item) {
        try {
            const { name, price, adicional_id, adicional_name, state } = req.body.item;
            const additionalData = {
                name, price, adicional_id, adicional_name, state
            };
            //  console.log(menuData
            var sql = "INSERT INTO additional_item SET ? "
            try {
                await db.query(sql, additionalData, (error, result, fields) => {
                    if (error) {
                        const errorMessage = error.sqlMessage;
                        return res.status(400).send(errorMessage);
                    } else {
                        res.send(req.body.item);
                    }
                });
            
            } catch (error) {
                return res.status(400).send(error);
            }
           
        } catch (error) {
           
        }
    }
});

module.exports = router;