const router = require("express").Router();
const verify = require("./validateToken");
const db = require("../database/connection");
const fs = require("fs");

router.get("/", verify, async (req, res) => {
  const sql = "SELECT * FROM delivery_boy where state = 1 and deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "No ay Lista de Motorizados!" });

      res.send({ delivertBoy: result, success: "true" });
    }
  });
  db.end;
});

router.post("/assign", verify, async (req, res) => {
  if (req.body.item) {
    try {
      const state = 2;
      const { id, delivery_boy_id, delivery_boy_name } = req.body.item;
      const deliveryBoyData = {
        delivery_boy_id,
        delivery_boy_name,
        state,
      };
      //  console.log(menuData
      var sql = "UPDATE cart SET ? WHERE id = " + id + "";
      try {
        await db.query(sql, deliveryBoyData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });

        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    } catch (error) {}
  }
});

router.post("/updateDeliveryZones/:id", verify, async (req, res) => {
  if (req.body.item) {
    const { id, name, store_id, store_name, coordinates, state } =
      req.body.item;
    const deliveryZoneData = {
      name,
      store_id,
      store_name,
      coordinates,
      state,
    };
    var sql = "UPDATE delivery_zone SET ? WHERE id = " + id + "";
    try {
      await db.query(sql, deliveryZoneData, (error, result, fields) => {
        if (error) {
          const errorMessage = error.sqlMessage;
          return res.status(400).send(errorMessage);
        } else {
          res.send(req.body.item);
        }
      });
      db.end;
    } catch (error) {
      return res.status(400).send(error);
    }
  }
});
router.get("/getDeliveryBoy/:id", verify, async (req, res) => {
  const id = req.params.id;

  const sql = "SELECT * FROM delivery_boy where id = " + id + "";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "El menú esta vacío!" });

      console.log(result);
      res.send({ delivertBoy: result, success: "true" });
    }
  });
  db.end;
});

// Additional Items Calls

router.get("/item", verify, async (req, res) => {
  const sql = "SELECT * FROM additional_item where deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "El menú esta vacío!" });

      res.send({ menu: result, success: "true" });
    }
  });
  db.end;
});

router.post("/saveAdditionalItem", verify, async (req, res) => {
  if (req.body.item) {
    try {
      const { name, price, adicional_id, adicional_name, state } =
        req.body.item;
      const additionalData = {
        name,
        price,
        adicional_id,
        adicional_name,
        state,
      };
      //  console.log(menuData
      var sql = "INSERT INTO additional_item SET ? ";
      try {
        await db.query(sql, additionalData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    } catch (error) {}
  }
});

router.post("/save", verify, async (req, res) => {
  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/deliveryBoy/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/deliveryBoy/" + url;

    fs.writeFile(
      path,
      base64Image,
      { encoding: "base64" },
      async function (err) {
        if (err) {
          res.send({ err });
          console.log(err);
        } else {
          try {
            const {
              store_id,
              store_name,
              name,
              placa,
              dni,
              phone,
              email,
              address,
              city,
              licence,
              category,
              clase,
              gender,
              state,
            } = req.body.item;
            const menuData = {
              store_id,
              store_name,
              name,
              placa,
              dni,
              phone,
              email,
              address,
              avator: img,
              city,
              licence,
              clase,
              category,
              gender,
              state,
            };

            var sql = "INSERT INTO delivery_boy SET ? ";

            try {
              await db.query(sql, menuData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          } catch (error) {}
        }
      }
    );
  }
});

router.post("/updateDeliveryBoy", async (req, res) => {
  const id = req.body.item.id;
  // if (req.body.item.img.length < 500) {
  //   console.log("String");
  // } else {
  //   console.log("Image");
  // }

  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/deliveryBoy/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/deliveryBoy/" + url;

    if (image.includes("base64")) {
      fs.writeFile(
        path,
        base64Image,
        { encoding: "base64" },
        async function (err) {
          if (err) {
            res.send({ err });
            console.log(err);
          } else {
            const {
              store_id,
              store_name,
              name,
              placa,
              dni,
              phone,
              email,
              address,
              city,
              licence,
              category,
              clase,
              gender,
              state,
            } = req.body.item;
            const menuData = {
              store_id,
              store_name,
              name,
              placa,
              dni,
              phone,
              email,
              address,
              avator: img,
              city,
              licence,
              clase,
              category,
              gender,
              state,
            };
            var sql = "UPDATE delivery_boy SET ? WHERE id = " + id + "";

            try {
              await db.query(sql, menuData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          }
        }
      );
    } else {
      const {
        store_id,
        store_name,
        name,
        placa,
        dni,
        phone,
        email,
        address,
        city,
        licence,
        category,
        clase,
        gender,
        state,
      } = req.body.item;
      const menuData = {
        store_id,
        store_name,
        name,
        placa,
        dni,
        phone,
        email,
        address,
        city,
        licence,
        clase,
        category,
        gender,
        state,
      };
      //  console.log(menuData)

      var sql = "UPDATE delivery_boy SET ? WHERE id = " + id + "";

      try {
        await db.query(sql, menuData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  }
});

router.post("/deleteDeliveryBoy/:id", verify, async (req, res) => {
  const id = req.params.id;
  console.log(id);
  const deleted = 1;
  const menuData = { deleted };

  var sql = "UPDATE delivery_boy SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, menuData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send(id);
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.get("/getDeliveryBoyByStoreId/:id", verify, async (req, res) => {
  const id = req.params.id;
  console.log(id);
  const sql = "SELECT * FROM delivery_boy where store_id = " + id + "";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "El menú esta vacío!" });

      console.log(result);
      res.send({ delivertBoy: result, success: "true" });
    }
  });
  db.end;
});

module.exports = router;
