const router = require("express").Router();
const verify = require("./validateToken");
const db = require("../database/connection");
const fs = require("fs");
var voucher_codes = require("voucher-code-generator");
const { exit } = require("process");

router.get("/", verify, async (req, res) => {
  const sql = "SELECT * FROM coupon where deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(200)
          .send({ success: "false", message: "No ay coupones desponisble!" });

      res.send({ coupon: result, success: "true" });
    }
  });
  db.end;
});

router.post("/saveCoupon", verify, async (req, res) => {
  var today = new Date().getTime().toString();

  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/coupon/" + req.body.item.name + today + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + today + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/coupon/" + url;

    // const code = voucher_codes[0]
    const genCode = voucher_codes.generate({
      length: 12,
      count: 1,
    });

    const code = genCode[0];

    fs.writeFile(
      path,
      base64Image,
      { encoding: "base64" },
      async function (err) {
        if (err) {
          res.send({ err });
          console.log(err);
        } else {
          try {
            const {
              name,
              state,
              description,
              amount,
              type,
              des_type,
              percent,
              product_id,
              product_name,
              points,
              is_public,
            } = req.body.item;
            const couponData = {
              img,
              name,
              state,
              description,
              amount,
              type,
              des_type,
              percent,
              product_id,
              product_name,
              points,
              is_public,
              code,
            };
            //  console.log(couponData)

            var sql = "INSERT INTO coupon SET ? ";

            try {
              await db.query(sql, couponData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          } catch (error) {}
        }
      }
    );
  }
});

router.post("/updateCoupon/:id", async (req, res) => {
  var today = new Date().getTime().toString();
  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/coupon/" + req.body.item.name + today + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + today + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/coupon/" + url;

    // const code = voucher_codes[0]
    const genCode = voucher_codes.generate({
      length: 12,
      count: 1,
    });

    const code = genCode[0];

    if (image.includes("base64")) {
      fs.writeFile(
        path,
        base64Image,
        { encoding: "base64" },
        async function (err) {
          if (err) {
            res.send({ err });
            console.log(err);
          } else {
            const {
              id,
              name,
              state,
              description,
              amount,
              type,
              des_type,
              percent,
              product_id,
              product_name,
              points,
              is_public,
            } = req.body.item;
            const couponData = {
              img,
              name,
              state,
              description,
              amount,
              type,
              des_type,
              percent,
              product_id,
              product_name,
              points,
              is_public,
              code,
            };
            //  console.log(couponData)

            var sql = "UPDATE coupon SET ? WHERE id = " + id + "";

            try {
              await db.query(sql, couponData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          }
        }
      );
    } else {
      const {
        id,
        name,
        state,
        description,
        amount,
        type,
        des_type,
        percent,
        product_id,
        product_name,
        points,
        is_public,
      } = req.body.item;
      const couponData = {
        img,
        name,
        state,
        description,
        amount,
        type,
        des_type,
        percent,
        product_id,
        product_name,
        points,
        is_public,
        code,
      };
      //  console.log(couponData)

      var sql = "UPDATE coupon SET ? WHERE id = " + id + "";

      try {
        await db.query(sql, couponData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  }
});

router.post("/deleteCoupon/:id", async (req, res) => {
  const id = req.params.id;
  const deleted = 1;
  const couponData = { deleted };

  var sql = "UPDATE coupon SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, couponData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send(id);
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

// Mobile App Section
router.get("/all", verify, async (req, res) => {
  const sql =
    "SELECT * FROM coupon where deleted = 0 and is_public = 1 ORDER BY points";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(200)
          .send({ success: "false", message: "No ay coupones desponisble!" });

      res.send({ coupon: result, success: "true" });
    }
  });
  db.end;
});

router.get("/byUser/:userId", verify, async (req, res) => {
  const id = req.params.userId;

  const sql =
    "SELECT c.* FROM `user_coupon` uc, coupon c where uc.coupon_id = c.id and uc.user_id = " +
    id +
    " and c.state =1 and c.deleted = 0 and c.is_public = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      // if (result.length === 0) return res.status(400).send({ success: "false", message: "No ay coupones desponisble!" });

      res.send({ coupons: result, success: "true" });
    }
  });
  db.end;
});

module.exports = router;
