const router = require("express").Router();
const verify = require("./validateToken");
const { addressValidation } = require("../utilities/validator");
const db = require("../database/connection");

router.get("/ss", async (req, res) => {
  const sql =
    'SELECT *, CONCAT(name, " ", surname) as nombre FROM user where state = 1';
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res.status(400).send({
          success: "false",
          message: "No ay ningun categoria grabado!",
        });

      res.send({ clients: result, success: "true" });
    }
  });
  db.end;
});

router.get("/", verify, async (req, res) => {
  const sql =
    'SELECT *, CONCAT(name, " ", surname) as nombre FROM user where state = 1';
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res.status(400).send({
          success: "false",
          message: "No ay ningun categoria grabado!",
        });

      res.send({ clients: result, success: "true" });
    }
  });
  db.end;
});

router.get("/getUser/:id", async (req, res) => {
  const id = req.params.id;
  var sql = "Select * from  user  WHERE id = " + id + "";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res.status(400).send({
          success: "false",
          message: "No ay ningun categoria grabado!",
        });
      res.send({ client: result, success: "true" });
    }
  });
  db.end;
});

router.get("/getPrivateCoupons", async (req, res) => {
  var sql = "Select * from  coupon  WHERE is_public = 0 and state = 1";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "No ay ningun copones!" });
      res.send({ coupons: result, success: "true" });
    }
  });
  db.end;
});

router.post("/assignCoupon", async (req, res) => {
  const { coupon_id, user_id } = req.body.item;
  const data = { coupon_id, user_id };

  // check if record excist
  var sqlCheck =
    "SELECT * FROM user_coupon WHERE coupon_id = " +
    coupon_id +
    " and  user_id = " +
    user_id +
    "";

  db.query(sqlCheck, async (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length > 0) {
        var sql =
          "UPDATE user_coupon SET state = IF(state = 1, 0, 1) where coupon_id = " +
          coupon_id +
          " and  user_id = " +
          user_id +
          "";
        await db.query(sql, data, (error, result) => {
          if (error) {
            return res.status(400).send(error.sqlMessage);
          } else {
            if (result.length === 0) return res.status(400).send({});
            res.send(req.body.item);
          }
        });
      } else {
        var sql = "INSERT INTO user_coupon SET ?";
        await db.query(sql, data, (error, result) => {
          if (error) {
            return res.status(400).send(error.sqlMessage);
          } else {
            if (result.length === 0)
              return res.status(400).send({
                success: "false",
                message: "No ay ningun categoria grabado!",
              });
            res.send(req.body.item);
          }
        });
      }
    }
  });

  db.end;
});

router.get("/assignedCoupons/:userId", verify, async (req, res) => {
  const id = req.params.userId;

  const sql =
    "SELECT * FROM `user_coupon` where user_id = " + id + " and state =1";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      res.send({ coupons: result, success: "true" });
    }
  });
  db.end;
});

module.exports = router;
