const router = require("express").Router();
const verify = require("./validateToken");
const { addressValidation } = require("../utilities/validator");
const db = require("../database/connection");
const fs = require("fs");

router.get("/", verify, async (req, res) => {
  const sql = "SELECT * FROM category where deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({
            success: "false",
            message: "No ay ningun categoria grabado!",
          });

      res.send({ categories: result, success: "true" });
    }
  });
  db.end;
});

router.post("/saveCategory", verify, async (req, res) => {
  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/menu/category/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/menu/category/" + url;

    fs.writeFile(
      path,
      base64Image,
      { encoding: "base64" },
      async function (err) {
        if (err) {
          res.send({ err });
          console.log(err);
        } else {
          try {
            const { name, state } = req.body.item;
            const categoryData = {
              name,
              img,
              state,
            };
            //  console.log(menuData)

            var sql = "INSERT INTO category SET ? ";

            try {
              await db.query(sql, categoryData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          } catch (error) {}
        }
      }
    );
  }
});

router.post("/updateCategory/:id", async (req, res) => {
  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/menu/category/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/menu/category/" + url;

    if (image.includes("base64")) {
      fs.writeFile(
        path,
        base64Image,
        { encoding: "base64" },
        async function (err) {
          if (err) {
            res.send({ err });
            console.log(err);
          } else {
            const { id, name, state } = req.body.item;
            const categoryData = {
              name,
              img,
              state,
            };
            //  console.log(menuData)

            var sql = "UPDATE category SET ? WHERE id = " + id + "";

            try {
              await db.query(sql, categoryData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          }
        }
      );
    } else {
      const { id, name, state } = req.body.item;
      const categoryData = {
        name,
        state,
      };
      //  console.log(menuData)

      var sql = "UPDATE category SET ? WHERE id = " + id + "";

      try {
        await db.query(sql, categoryData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  }
});

router.post("/deleteCategory/:id", async (req, res) => {
  const id = req.params.id;
  const deleted = 1;
  const categoryData = { deleted };

  var sql = "UPDATE category SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, categoryData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send(id);
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

//  APP calls

router.get("/app", verify, async (req, res) => {
  const sql = "SELECT * FROM category where deleted = 0 and state = 1";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({
            success: "false",
            message: "No ay ningun categoria grabado!",
          });

      res.send({ categories: result, success: "true" });
    }
  });
  db.end;
});

module.exports = router;
