const router = require("express").Router();
const verify = require("./validateToken");
const { cardValidation } = require("../utilities/validator");
const db = require("../database/connection");

router.post("/", verify, async (req, res) => {
  console.log(req);
  const sql = "SELECT * FROM card where state = 1 and user_id = ?";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "No ay ningun tarjeta grabada!" });

      res.send({ cards: result, success: "true" });
    }
  });
  db.end;
});

router.post("/default", verify, async (req, res) => {
  // console.log(req.body.id);
  const sql =
    "SELECT * FROM card where state = 1 and user_id = ? and is_default = 1";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      console.log(result);
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "No ay ningun tarjeta grabada!" });

      res.send({ cards: result, success: "true" });
    }
  });
  db.end;
});

router.post("/setDefault", verify, async (req, res) => {
  // console.log(req.body.id);

  const userId = req.body.user_id;
  const id = req.body.id;

  var sql1 = "update card set is_default = 0 where user_id = " + userId + "";
  await db.query(sql1, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      // console.log("error",errorMessage);
      return res.status(400).send(error.sqlMessage);
    }
  });

  var sql =
    "update card set is_default = 1 where user_id = " +
    userId +
    " and id = " +
    id +
    "";
  await db.query(sql, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      // console.log("error",errorMessage);
      return res.status(400).send(error.sqlMessage);
    } else {
      res.send({ success: "true" });
    }
  });
  db.end;
});

router.post("/saveCard", verify, async (req, res) => {
  //validate the data
  const { error } = cardValidation(req.body);
  if (error) return res.status(400).send(error.details[0].message);

  const {
    user_id,
    card_holder_name,
    card_number,
    card_year,
    card_month,
    card_cvv,
  } = req.body;
  const cardData = {
    user_id,
    card_holder_name,
    card_number,
    card_year,
    card_month,
    card_cvv,
  };

  //  remove all defaults cards
  var sql1 = "update card set is_default = 0 where user_id = " + user_id + "";
  await db.query(sql1, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      // console.log("error",errorMessage);
      return res.status(400).send(error.sqlMessage);
    }
  });

  var sql = "INSERT INTO card SET ?";

  await db.query(sql, cardData, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      // console.log("error",errorMessage);
      return res.status(400).send(error.sqlMessage);
    } else {
      // console.log("Result",result);
      res.send({
        id: result.insertId,
        message: "card created",
        success: "true",
      });
    }
  });
  db.end;
});

router.post("/updateCard", async (req, res) => {
  console.log(req.body);

  const { id, card_holder_name, card_number, card_year, card_month, card_cvv } =
    req.body;
  const cardData = {
    card_holder_name,
    card_number,
    card_year,
    card_month,
    card_cvv,
  };

  var sql = "UPDATE card SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, cardData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send({ card: req.body, message: "card updated!", success: "true" });
      }
    });

    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

router.post("/deleteStore/:id", async (req, res) => {
  const id = req.params.id;
  const deleted = 1;
  const menuData = { deleted };

  var sql = "UPDATE store SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, menuData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send(id);
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

module.exports = router;
