const router = require("express").Router();
const db = require("../database/connection");
const fs = require("fs");

const {
  registerValidation,
  loginValidation,
} = require("../utilities/validator");
const bcrypt = require("bcryptjs");
const jwt = require("jsonwebtoken");
const verify = require("./validateToken");
const generator = require("generate-password");

const nodemailer = require("nodemailer");

router.post("/register", async (req, res) => {
  //validate the data
  const { error } = registerValidation(req.body);
  if (error) return res.status(400).send(error.details[0].message);

  //Hash the password
  const salt = await bcrypt.genSalt(10);
  const hashPassword = await bcrypt.hash(req.body.password, salt);

  const { name, surname, email, mobile } = req.body;
  const user = {
    name,
    surname,
    email,
    mobile,
    password: hashPassword,
  };

  var sql = "INSERT INTO user SET ?";

  await db.query(sql, user, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      if (errorMessage.includes("Duplicate entry")) {
        return res.status(400).send("Esta Correo fue registrado!");
      } else {
        return res.status(400).send(error.sqlMessage);
      }
    } else {
      res.send({
        id: result.insertId,
        message: "user created",
        success: "true",
      });
    }
  });

  db.end;
});

router.post("/login", async (req, res) => {
  //validate the data
  // console.log(req.body);
  const { error } = loginValidation(req.body);
  if (error) return res.status(400).send(error.details[0].message);

  //check if user exist
  const sql = "SELECT * FROM user where state = 1 and email = ?";
  await db.query(sql, req.body.email, async (error, result) => {
    if (error)
      return res
        .status(400)
        .send({ success: "false", message: error.details[0].message });

    if (result.length === 0)
      return res.status(400).send({
        success: "false",
        message: "Correo electrónico o la contraseña son incorrectos",
      });

    // check password is correct
    const password = result[0]["password"];
    const validPassword = await bcrypt.compare(req.body.password, password);
    if (!validPassword)
      return res.status(400).send({
        success: "false",
        message: "Correo electrónico o la contraseña son incorrectos",
      });

    // create a token
    const token = jwt.sign({ id: result[0]["id"] }, process.env.TOKEN_KEY);
    return res
      .status(200)
      .send({ user: result[0], token: token, success: "true" });
  });

  db.end;
});

// mobile

router.post("/editUser/:id", async (req, res) => {
  const id = req.params.id;
  const { name, surname, email, mobile } = req.body;
  const user = {
    name,
    surname,
    email,
    mobile,
  };

  console.log(user);

  var sql = "UPDATE user SET ?  WHERE id = " + id + "";

  await db.query(sql, user, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      if (errorMessage.includes("Duplicate entry")) {
        return res.status(400).send("Esta Correo fue registrado!");
      } else {
        return res.status(400).send(error.sqlMessage);
      }
    } else {
      res.send({
        message: "user updated",
        success: "true",
      });
    }
  });
});

router.post("/editPass/:id", async (req, res) => {
  const id = req.params.id;
  const salt = await bcrypt.genSalt(10);
  const hashPassword = await bcrypt.hash(req.body.newPassword, salt);

  const data = {
    password: hashPassword,
  };

  const sql = "SELECT * FROM user where id = ?";
  await db.query(sql, id, async (error, result, fields) => {
    if (error) {
      console.log(error);
      return res.status(400).send(error.sqlMessage);
    } else {
      const password = result[0]["password"];
      const validPassword = await bcrypt.compare(req.body.password, password);
      if (!validPassword) {
        console.log(validPassword);
        return res.status(400).send({
          success: "false",
          message: " anterior contraseña incorrecta",
        });
      }
    }

    var sql2 = "UPDATE user SET ?  WHERE id = " + id + "";

    await db.query(sql2, data, (error, result, fields) => {
      if (error) {
        console.log(error);
        return res.status(400).send(error.sqlMessage);
      } else {
        res.send({
          message: "user updated",
          success: "true",
        });
      }
    });
  });
});

router.post("/resetPassword", async (req, res) => {
  const { email } = req.body;

  //check if user exist
  const sql = "SELECT * FROM user where state = 1 and email = ?";
  await db.query(sql, req.body.email, async (error, result) => {
    if (error)
      return res
        .status(400)
        .send({ success: "false", message: error.details[0].message });

    if (result.length === 0)
      return res.status(400).send({
        success: "false",
        message: "Correo electrónico no existe!",
      });

    // if exict
    const password = generator.generate({
      length: 10,
      numbers: true,
    });
    // send emails
    const senderEmail = process.env.EMAIL_ADDRESS;
    const senderPassword = process.env.Email_PASSWORD;

    var transporter = nodemailer.createTransport({
      service: "gmail",
      auth: {
        user: senderEmail,
        pass: senderPassword,
      },
    });

    var mailOptions = {
      sender: "info@saki.com",
      to: "azzamraji@hotmail.com",
      subject: "Restablecer la contraseña",
      html: `
<!doctype html>
<html lang="en-US">

<head>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
    <title>Reset Password Email Template</title>
    <meta name="description" content="Reset Password Email Template.">
    <style type="text/css">
        a:hover {text-decoration: underline !important;}
    </style>
</head>

<body marginheight="0" topmargin="0" marginwidth="0" style="margin: 0px; background-color: #f2f3f8;" leftmargin="0">
    <!--100% body table-->
    <table cellspacing="0" border="0" cellpadding="0" width="100%" bgcolor="#f2f3f8"
        style="@import url(https://fonts.googleapis.com/css?family=Rubik:300,400,500,700|Open+Sans:300,400,600,700); font-family: 'Open Sans', sans-serif;">
        <tr>
            <td>
                <table style="background-color: #f2f3f8; max-width:670px;  margin:0 auto;" width="100%" border="0"
                    align="center" cellpadding="0" cellspacing="0">
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td style="text-align:center;">
                        
                            <img width="120" src="https://static.wixstatic.com/media/39b216_365cbb248eaa4e1f8ae2d68676df58ce~mv2.png/v1/crop/x_1,y_0,w_571,h_571/fill/w_120,h_120,al_c,q_85,usm_0.66_1.00_0.01,enc_auto/39b216_365cbb248eaa4e1f8ae2d68676df58ce~mv2.png" title="logo" alt="logo">
                          
                        </td>
                    </tr>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    <tr>
                        <td>
                            <table width="95%" border="0" align="center" cellpadding="0" cellspacing="0"
                                style="max-width:670px;background:#fff; border-radius:3px; text-align:center;-webkit-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);-moz-box-shadow:0 6px 18px 0 rgba(0,0,0,.06);box-shadow:0 6px 18px 0 rgba(0,0,0,.06);">
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                                <tr>
                                    <td style="padding:0 35px;">
                                        <h1 style="color:#1e1e2d; font-weight:500; margin:0;font-size:32px;font-family:'Rubik',sans-serif;">Ha solicitado restablecer su contraseña</h1>
                                        <span
                                            style="display:inline-block; vertical-align:middle; margin:29px 0 26px; border-bottom:1px solid #cecece; width:100px;"></span>
                                        <p style="color:#455056; font-size:15px;line-height:24px; margin:0;">
                                            Se ha generado una nueva contraseña para usted.
                                        </p>
                                        <p
                                            style="background:#ef7021;text-decoration:none !important; font-weight:500; margin-top:35px; color:#fff; font-size:14px;padding:10px 24px;display:inline-block;border-radius:50px;">${password}</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="height:40px;">&nbsp;</td>
                                </tr>
                            </table>
                        </td>
                    <tr>
                        <td style="height:20px;">&nbsp;</td>
                    </tr>
                    <tr>
                        
                    </tr>
                    <tr>
                        <td style="height:80px;">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <!--/100% body table-->
</body>

</html>`,
    };

    transporter.sendMail(mailOptions, async function (error, info) {
      if (error) {
        console.log(error);
      } else {
        console.log("Email sent: " + info.response);
        //Hash the password
        const salt = await bcrypt.genSalt(10);
        const hashPassword = await bcrypt.hash(password, salt);

        const userId = result[0]["id"];
        const data = {
          password: hashPassword,
        };

        var sql = "UPDATE user SET ?  WHERE id = " + userId + "";

        await db.query(sql, data, (error, result, fields) => {
          if (error) {
            console.log(error);
            return res.status(400).send(error.sqlMessage);
          } else {
            console.log(result);
            res.send({
              message: "user updated",
              success: "true",
            });
          }
        });
      }
    });
  });
});

// Admin Auth Handling
router.post("/admin/login", async (req, res) => {
  //validate the data
  const { error } = loginValidation(req.body);
  if (error) return res.status(400).send(error.details[0].message);

  //check if user exist
  const sql = "SELECT * FROM admin where state = 1 and email = ?";
  await db.query(sql, req.body.email, async (error, result) => {
    if (error)
      return res
        .status(400)
        .send({ success: "false", message: error.details[0].message });

    if (result.length === 0)
      return res.status(400).send({
        success: "false",
        message: "Correo electrónico o la contraseña son incorrectos",
      });

    // check password is correct
    const password = result[0]["password"];
    const validPassword = await bcrypt.compare(req.body.password, password);
    if (!validPassword)
      return res.status(400).send({
        success: "false",
        message: "Correo electrónico o la contraseña son incorrectos",
      });

    // create a token
    const token = jwt.sign({ id: result[0]["id"] }, process.env.TOKEN_KEY);
    return res
      .status(200)
      .send({ user: result[0], token: token, success: "true" });
  });

  db.end;
});

router.get("/admin/procedure", verify, async (req, res) => {
  //check if user exist
  const sql = "call get_admins()";
  await db.query(sql, async (error, result) => {
    if (error)
      return res
        .status(400)
        .send({ success: "false", message: error.details[0].message });
    return res.status(200).send({ user: result[0], success: "true" });
  });

  db.end;
});

router.get("/users", verify, async (req, res) => {
  //validate the data
  var sql = "SELECT *, picture as avatar from admin ";

  await db.query(sql, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      return res.status(400).send(error.sqlMessage);
    } else {
      res.send({ users: result, success: "true" });
    }
  });

  db.end;
});

router.get("/getUser/:id", async (req, res) => {
  const id = req.params.id;
  var sql = "Select * , picture as avatar from  admin  WHERE id = " + id + "";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "No ay usuario con esta id!" });
      res.send({ users: result, success: "true" });
    }
  });
  db.end;
});

router.post("/updateAdmin", async (req, res) => {
  const id = req.body.item.id;
  // console.log(req.body.item);
  // return;
  if (req.body.item) {
    const image = req.body.item.avatar;
    const fileName = "./storage/user/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/user/" + url;

    var password = req.body.item.password;
    if (req.body.item.isEditPassword) {
      const salt = await bcrypt.genSalt(10);
      password = await bcrypt.hash(req.body.item.password, salt);
    }

    if (image.includes("base64")) {
      fs.writeFile(
        path,
        base64Image,
        { encoding: "base64" },
        async function (err) {
          if (err) {
            res.send({ err });
            console.log(err);
          } else {
            const {
              store_id,
              store_name,
              name,
              displayName,
              userRole,
              phone,
              email,
              address,
              city,
              gender,
              state,
            } = req.body.item;
            const menuData = {
              store_id,
              store_name,
              name,
              displayName,
              userRole,
              phone,
              email,
              address,
              picture: img,
              city,
              gender,
              state,
              password: password,
            };
            var sql = "UPDATE admin SET ? WHERE id = " + id + "";

            try {
              await db.query(sql, menuData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          }
        }
      );
    } else {
      const {
        store_id,
        store_name,
        name,
        displayName,
        userRole,
        phone,
        email,
        address,
        city,
        gender,
        state,
      } = req.body.item;
      const menuData = {
        store_id,
        store_name,
        name,
        displayName,
        userRole,
        phone,
        email,
        address,
        city,
        gender,
        state,
        password: password,
      };
      //  console.log(menuData)

      var sql = "UPDATE admin SET ? WHERE id = " + id + "";

      try {
        await db.query(sql, menuData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  }
});

router.post("/addAdmin", async (req, res) => {
  const id = req.body.item.id;

  //Hash the password
  const salt = await bcrypt.genSalt(10);
  const hashPassword = await bcrypt.hash(req.body.item.password, salt);

  if (req.body.item) {
    const image = req.body.item.img;
    const fileName = "./storage/user/" + req.body.item.name + ".png";
    const path = fileName.replace(/\s+/g, "");
    // Remove header
    const base64Image = image.split(";base64,").pop();

    const file_name = req.body.item.name + ".png";
    const url = file_name.replace(/\s+/g, "");
    const img = process.env.BASE_PATH + "storage/user/" + url;

    if (image.includes("base64")) {
      fs.writeFile(
        path,
        base64Image,
        { encoding: "base64" },
        async function (err) {
          if (err) {
            res.send({ err });
            console.log(err);
          } else {
            const {
              store_id,
              store_name,
              name,
              displayName,
              userRole,
              phone,
              email,
              address,
              city,
              gender,
              state,
            } = req.body.item;
            const adminData = {
              store_id,
              store_name,
              name,
              displayName,
              userRole,
              phone,
              email,
              address,
              picture: img,
              city,
              gender,
              state,
              password: hashPassword,
            };
            var sql = "INSERT INTO admin SET ?";

            try {
              await db.query(sql, adminData, (error, result, fields) => {
                if (error) {
                  const errorMessage = error.sqlMessage;
                  return res.status(400).send(errorMessage);
                } else {
                  res.send(req.body.item);
                }
              });
              db.end;
            } catch (error) {
              return res.status(400).send(error);
            }
          }
        }
      );
    } else {
      const {
        store_id,
        store_name,
        name,
        displayName,
        userRole,
        phone,
        email,
        address,
        city,
        gender,
        state,
      } = req.body.item;
      const adminData = {
        store_id,
        store_name,
        name,
        displayName,
        userRole,
        phone,
        email,
        address,
        city,
        gender,
        state,
        password: hashPassword,
      };
      //  console.log(menuData)

      var sql = "INSERT INTO admin SET ?";

      try {
        await db.query(sql, menuData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  }
});

router.get("/settings", async (req, res) => {
  var sql = "SELECT * from settings ";

  await db.query(sql, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      return res.status(400).send(error.sqlMessage);
    } else {
      res.send({ settings: result, success: "true" });
    }
  });
});

router.post("/updateValueSettings/:id", async (req, res) => {
  console.log(req.body.item);
  if (req.body.item) {
    const { id, state } = req.body.item;
    var sql = "UPDATE settings SET value = " + state + " WHERE id = " + id;
    try {
      await db.query(sql, (error, result, fields) => {
        if (error) {
          const errorMessage = error.sqlMessage;
          return res.status(400).send(errorMessage);
        } else {
          res.send(req.body.item);
        }
      });
      db.end;
    } catch (error) {
      return res.status(400).send(error);
    }
  }
});

module.exports = router;
