const router = require("express").Router();
const verify = require("./validateToken");
const { addressValidation } = require("../utilities/validator");
const db = require("../database/connection");

router.post("/", verify, async (req, res) => {
  console.log(req);
  const sql = "SELECT * FROM address where state = 1 and user_id = ?";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res.status(400).send({
          success: "false",
          message: "No ay ningun dirección grabado!",
        });

      res.send({ addresses: result, success: "true" });
    }
  });
  db.end;
});

router.post("/gettById", verify, async (req, res) => {
  const sql = "SELECT * FROM address where state = 1 and id= ?";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res.status(400).send({
          success: "false",
          message: "No ay ningun dirección grabado!",
        });

      res.send({ addresses: result, success: "true" });
    }
  });
  db.end;
});

router.post("/saveAddress", verify, async (req, res) => {
  //validate the data
  const { error } = addressValidation(req.body);
  if (error) return res.status(400).send(error.details[0].message);

  const {
    user_id,
    name,
    address,
    ext_number,
    int_number,
    reference,
    store_id,
    lat,
    longit,
  } = req.body;
  const addressData = {
    user_id,
    name,
    address,
    ext_number,
    int_number,
    reference,
    store_id,
    lat,
    longit,
  };

  var sql = "INSERT INTO address SET ?";

  await db.query(sql, addressData, (error, result, fields) => {
    if (error) {
      const errorMessage = error.sqlMessage;
      // console.log("error",errorMessage);
      return res.status(400).send(error.sqlMessage);
    } else {
      // console.log("Result",result);
      res.send({
        id: result.insertId,
        message: "address created",
        success: "true",
      });
    }
  });
  db.end;
});

module.exports = router;
