const router = require("express").Router();
const verify = require("./validateToken");
const db = require("../database/connection");

router.get("/", verify, async (req, res) => {
  const sql = "SELECT * FROM additional where deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "El menú esta vacío!" });

      res.send({ menu: result, success: "true" });
    }
  });
  db.end;
});

router.post("/saveAdditional", verify, async (req, res) => {
  if (req.body.item) {
    try {
      const { name, limits, required, state } = req.body.item;
      const additionalData = {
        name,
        limits,
        required,
        state,
      };
      //  console.log(menuData
      var sql = "INSERT INTO additional SET ? ";
      try {
        await db.query(sql, additionalData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    } catch (error) {}
  }
});

router.post("/updateAdditional/:id", verify, async (req, res) => {
  if (req.body.item) {
    const { id, name, limits, required, state } = req.body.item;
    const additionalData = {
      name,
      limits,
      required,
      state,
    };
    var sql = "UPDATE additional SET ? WHERE id = " + id + "";
    try {
      await db.query(sql, additionalData, (error, result, fields) => {
        if (error) {
          const errorMessage = error.sqlMessage;
          return res.status(400).send(errorMessage);
        } else {
          res.send(req.body.item);
        }
      });
      db.end;
    } catch (error) {
      return res.status(400).send(error);
    }
  }
});

router.post("/updateAdditionalItem/:id", verify, async (req, res) => {
  if (req.body.item) {
    const { id, adicional_id, adicional_name, name, price, state } =
      req.body.item;
    const additionalData = {
      adicional_id,
      adicional_name,
      name,
      price,
      state,
    };
    var sql = "UPDATE additional_item SET ? WHERE id = " + id + "";
    try {
      await db.query(sql, additionalData, (error, result, fields) => {
        if (error) {
          const errorMessage = error.sqlMessage;
          return res.status(400).send(errorMessage);
        } else {
          res.send(req.body.item);
        }
      });
      db.end;
    } catch (error) {
      return res.status(400).send(error);
    }
  }
});

router.post("/deleteAdditional/:id", verify, async (req, res) => {
  const id = req.params.id;
  const deleted = 1;
  const menuData = { deleted };

  var sql = "UPDATE additional SET ? WHERE id = " + id + "";

  try {
    await db.query(sql, menuData, (error, result, fields) => {
      if (error) {
        const errorMessage = error.sqlMessage;
        return res.status(400).send(errorMessage);
      } else {
        res.send(id);
      }
    });
    db.end;
  } catch (error) {
    return res.status(400).send(error);
  }
});

// Additional Items Calls

router.get("/item", verify, async (req, res) => {
  const sql = "SELECT * FROM additional_item where deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "El menú esta vacío!" });

      res.send({ menu: result, success: "true" });
    }
  });
  db.end;
});

router.post("/saveAdditionalItem", verify, async (req, res) => {
  if (req.body.item) {
    try {
      const { name, price, adicional_id, adicional_name, state } =
        req.body.item;
      const additionalData = {
        name,
        price,
        adicional_id,
        adicional_name,
        state,
      };
      //  console.log(menuData
      var sql = "INSERT INTO additional_item SET ? ";
      try {
        await db.query(sql, additionalData, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
        db.end;
      } catch (error) {
        return res.status(400).send(error);
      }
    } catch (error) {}
  }
});

//  staff

router.post("/staffAdditional/:id", verify, async (req, res) => {
  // TODO make store_id dinamic

  const id = req.params.id;
  const sql =
    "SELECT m.* , sm.state as storeState FROM `additional_item` m , staff_additional_item  sm where sm.store_id = " +
    id +
    " and m.id = sm.additional_item_id and m.state = 1 and m.deleted = 0";
  await db.query(sql, req.body.id, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res.status(400).send({
          success: "false",
          message: "No ay ningun dirección grabado!",
        });

      res.send({ menu: result, success: "true" });
    }
  });
  db.end;
});

router.post("/updateState/:id", async (req, res) => {
  if (req.body.item) {
    const { id, storeId, state } = req.body.item;
    var sql =
      "UPDATE staff_additional_item SET state = " +
      state +
      " WHERE additional_item_id = " +
      id +
      " and store_id = " +
      storeId +
      "";
    try {
      await db.query(sql, (error, result, fields) => {
        if (error) {
          const errorMessage = error.sqlMessage;
          return res.status(400).send(errorMessage);
        } else {
          res.send(req.body.item);
        }
      });
      db.end;
    } catch (error) {
      return res.status(400).send(error);
    }
  }
});

router.post("/checkAssign/:id", verify, async (req, res) => {
  const id = req.params.id;
  const sql =
    "SELECT m.*, sm.id as isAssigned FROM `additional_item` m left JOIN staff_additional_item sm on sm.store_id = " +
    id +
    " and sm.additional_item_id = m.id and sm.deleted = 0";
  await db.query(sql, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res
          .status(400)
          .send({ success: "false", message: "El menú esta vacío!" });

      res.send({ menu: result, success: "true" });
    }
  });
  db.end;
});

router.post("/updateAssignAdditional", async (req, res) => {
  // console.log(req.body.item); return null;

  const id = req.body.item.id;
  const isChecked = req.body.item.isChecked;
  const storeId = req.body.item.storeId;

  const deleted = isChecked === true ? 0 : 1;
  // console.log(deleted)
  // return
  //check if user exist
  const sql =
    "SELECT * FROM staff_additional_item where store_id = " +
    storeId +
    " and additional_item_id = " +
    id +
    ";";

  await db.query(sql, async (error, result) => {
    if (error)
      return res
        .status(400)
        .send({ success: "false", message: error.details[0].message });

    if (result.length === 0) {
      var sql2 =
        "INSERT INTO staff_additional_item (additional_item_id, store_id ) VALUE(" +
        id +
        "," +
        storeId +
        ")";
      try {
        await db.query(sql2, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
      } catch (error) {
        return res.status(400).send(error);
      }
    } else {
      var sql2 =
        "UPDATE staff_additional_item SET deleted = " +
        deleted +
        " WHERE additional_item_id = " +
        id +
        " and store_id = " +
        storeId +
        "";
      console.log(sql2);
      try {
        await db.query(sql2, (error, result, fields) => {
          if (error) {
            const errorMessage = error.sqlMessage;
            return res.status(400).send(errorMessage);
          } else {
            res.send(req.body.item);
          }
        });
      } catch (error) {
        return res.status(400).send(error);
      }
    }
  });
  db.end;
});

//  App Calls

router.post("/app", verify, async (req, res) => {
  //  get additional list

  const additionalList = [];

  const sql1 = "SELECT * FROM additional where deleted = 0";
  await db.query(sql1, (error, result) => {
    if (error) {
      console.log(error.sqlMessage);
    } else {
      for (additional of result) {
        additionalList.push(additional["name"]);
      }
    }
  });

  // const id = req.body.storeId
  // const sql = 'SELECT m.* , sm.state as storeState, a.name as ad_name  FROM `additional_item` m , staff_additional_item  sm, additional a where sm.store_id = '+id+' and m.id = sm.additional_item_id and m.state = 1 and m.deleted = 0 and m.adicional_id = a.id';
  const menuId = req.body.menuId;
  const storeId = req.body.storeId;
  const sql =
    "SELECT a.*, ad.limits, ad.required FROM additional ad, additional_item a , menu_additional ma, staff_menu s, staff_additional_item sa where sa.state = 1 and sa.store_id = " +
    storeId +
    " and a.id = sa.additional_item_id and a.deleted = 0 and a.state = 1 and ma.menu_id = " +
    menuId +
    " and s.store_id = " +
    storeId +
    " and ma.menu_id = s.menu_id and a.id = ma.additional_id and ma.deleted = 0 and ma.state = 1 and ad.id = a.adicional_id";

  await db.query(sql, (error, result) => {
    if (error) {
      return res.status(400).send(error.sqlMessage);
    } else {
      if (result.length === 0)
        return res.status(400).send({
          success: "false",
          message: "No ay ningun dirección grabado!",
        });

      // Toppings
      // var bedrooms = result.filter(ad_name => ad_name.includes('Toppings'))
      const additionalResult = [];
      for (additional of additionalList) {
        var additionalFilter = result.filter(function (result) {
          return result.adicional_name == additional;
        });
        if (additionalFilter.length > 0) {
          additionalResult.push({ [additional]: additionalFilter });
        }
      }

      res.send({ additonal: additionalResult, success: "true" });
    }
  });
  db.end;
});

module.exports = router;
