const express = require("express");
const app = express();
const cors = require("cors");
const upload = require("express-fileupload");
const socketIO = require("./src/utilities/socketio");

// Settings
app.set("port", process.env.PORT || 3000);

//Import routes
const authRoute = require("./src/routes/auth");
const addressRoute = require("./src/routes/address");
const categoryRoute = require("./src/routes/category");
const menuRoute = require("./src/routes/menu");
const additionalRoute = require("./src/routes/additional");
const deliverZonesRoute = require("./src/routes/deliveryZones");
const couponRoute = require("./src/routes/coupon");
const clientRoute = require("./src/routes/client");
const storeRoute = require("./src/routes/store");
const cardRoute = require("./src/routes/card");
const mercadoPago = require("./src/routes/mercadoPago");
const orderRoute = require("./src/routes/order");
const deliveryBoyRoute = require("./src/routes/deliveryBoy");
const testRoute = require("./src/routes/test");

//Middlewares
app.use(express.json({ limit: "50mb" }));
app.use(express.urlencoded({ limit: "50mb" }));
app.use(express.json());
app.use(cors());
app.use(upload());

// app.use(express.static('/storage/'));
app.use("/storage", express.static("storage"));

//Routes Middlewares
app.use("/api/user", authRoute);
app.use("/api/address", addressRoute);
app.use("/api/category", categoryRoute);
app.use("/api/menu", menuRoute);
app.use("/api/additional", additionalRoute);
app.use("/api/deliveryZones", deliverZonesRoute);
app.use("/api/coupon", couponRoute);
app.use("/api/client", clientRoute);
app.use("/api/store", storeRoute);
app.use("/api/card", cardRoute);
app.use("/api/payment", mercadoPago);
app.use("/api/order", orderRoute);
app.use("/api/deliveryBoy", deliveryBoyRoute);
app.use("/api/test", testRoute);

// https://static.wixstatic.com/media/39b216_2fcda16938044b898d930ed73c65d786~mv2.png
app.listen(app.get("port"), () => {
  console.log("Server up and running :" + app.get("port"));
  console.log(__dirname + "/storage/menu/menu");
});
